/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.misc;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.eydamos.backpack.Backpack;
import de.eydamos.backpack.network.message.MessageBackpackInfoRequest;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@SideOnly(value=Side.CLIENT)
public class BackpackUsageCache {
    private static final Map<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();
    private static final Map<String, Long> requestTimestamps = new ConcurrentHashMap<String, Long>();
    private static final long CACHE_DURATION_MS = 60000L;
    private static final long REQUEST_THROTTLE_MS = 1000L;
    private static final int MAX_CACHE_SIZE = 100;
    private static final ReadWriteLock cacheLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateBackpackInfo(String uuid, int used, int total) {
        if (uuid == null || uuid.trim().isEmpty()) {
            throw new IllegalArgumentException("UUID cannot be null or empty");
        }
        BackpackSlotUsageInfo info = new BackpackSlotUsageInfo(used, total);
        long currentTime = System.currentTimeMillis();
        CacheEntry entry = new CacheEntry(info, currentTime);
        cacheLock.writeLock().lock();
        try {
            cache.put(uuid, entry);
            if (cache.size() > 100) {
                BackpackUsageCache.evictOldestEntries();
            }
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    public static BackpackSlotUsageInfo getBackpackInfo(String uuid) {
        if (uuid == null || uuid.trim().isEmpty()) {
            return null;
        }
        CacheEntry entry = cache.get(uuid);
        if (entry == null) {
            return null;
        }
        if (entry.isExpired()) {
            BackpackUsageCache.invalidate(uuid);
            return null;
        }
        return entry.info;
    }

    public static void requestBackpackInfo(String uuid) {
        if (uuid == null || uuid.trim().isEmpty()) {
            return;
        }
        if (BackpackUsageCache.getBackpackInfo(uuid) != null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        requestTimestamps.compute(uuid, (key, lastRequestTime) -> {
            if (lastRequestTime != null && currentTime - lastRequestTime < 1000L) {
                return lastRequestTime;
            }
            Backpack.packetHandler.networkWrapper.sendToServer((IMessage)new MessageBackpackInfoRequest((String)key));
            return currentTime;
        });
    }

    public static void invalidate(String uuid) {
        if (uuid == null || uuid.trim().isEmpty()) {
            return;
        }
        cache.remove(uuid);
        requestTimestamps.remove(uuid);
    }

    private static void evictOldestEntries() {
        if (cache.size() <= 100) {
            return;
        }
        int entriesToEvict = Math.max(1, cache.size() / 10);
        cache.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingLong(e -> e.timestamp))).limit(entriesToEvict).map(Map.Entry::getKey).forEach(key -> {
            cache.remove(key);
            requestTimestamps.remove(key);
        });
    }

    public static class BackpackSlotUsageInfo {
        public final int usedSlots;
        public final int totalSlots;

        public BackpackSlotUsageInfo(int used, int total) {
            if (used < 0 || total < 0 || used > total) {
                throw new IllegalArgumentException("Invalid backpack slot values: used=" + used + ", total=" + total);
            }
            this.usedSlots = used;
            this.totalSlots = total;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            BackpackSlotUsageInfo that = (BackpackSlotUsageInfo)obj;
            return this.usedSlots == that.usedSlots && this.totalSlots == that.totalSlots;
        }

        public int hashCode() {
            return 31 * this.usedSlots + this.totalSlots;
        }

        public String toString() {
            return "BackpackInfo{used=" + this.usedSlots + ", total=" + this.totalSlots + "}";
        }
    }

    private static class CacheEntry {
        public final BackpackSlotUsageInfo info;
        public final long timestamp;

        public CacheEntry(BackpackSlotUsageInfo info, long timestamp) {
            this.info = info;
            this.timestamp = timestamp;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 60000L;
        }
    }
}

